<?php

declare(strict_types=1);

namespace GitList\SCM;

class Language
{
    public const MAP = [
        'bsl' => [
            'name' => '1C Enterprise',
            'group' => null,
            'color' => '#814CCC',
            'ace' => 'text',
            'cm' => null,
        ],
        'os' => [
            'name' => '1C Enterprise',
            'group' => null,
            'color' => '#814CCC',
            'ace' => 'text',
            'cm' => null,
        ],
        'abap' => [
            'name' => 'ABAP',
            'group' => null,
            'color' => '#E8274B',
            'ace' => 'abap',
            'cm' => null,
        ],
        'abnf' => [
            'name' => 'ABNF',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'asc' => [
            'name' => 'Public Key',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'asciiarmor',
        ],
        'ash' => [
            'name' => 'AGS Script',
            'group' => null,
            'color' => '#B9D9FF',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'ampl' => [
            'name' => 'AMPL',
            'group' => null,
            'color' => '#E6EFBB',
            'ace' => 'text',
            'cm' => null,
        ],
        'mod' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'g4' => [
            'name' => 'ANTLR',
            'group' => null,
            'color' => '#9DC3FF',
            'ace' => 'text',
            'cm' => null,
        ],
        'apib' => [
            'name' => 'API Blueprint',
            'group' => null,
            'color' => '#2ACCA8',
            'ace' => 'markdown',
            'cm' => null,
        ],
        'apl' => [
            'name' => 'APL',
            'group' => null,
            'color' => '#5A8164',
            'ace' => 'text',
            'cm' => 'apl',
        ],
        'dyalog' => [
            'name' => 'APL',
            'group' => null,
            'color' => '#5A8164',
            'ace' => 'text',
            'cm' => 'apl',
        ],
        'asn' => [
            'name' => 'ASN.1',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'asn.1',
        ],
        'asn1' => [
            'name' => 'ASN.1',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'asn.1',
        ],
        'asp' => [
            'name' => 'ASP',
            'group' => null,
            'color' => '#6a40fd',
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'asax' => [
            'name' => 'ASP',
            'group' => null,
            'color' => '#6a40fd',
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'ascx' => [
            'name' => 'ASP',
            'group' => null,
            'color' => '#6a40fd',
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'ashx' => [
            'name' => 'ASP',
            'group' => null,
            'color' => '#6a40fd',
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'asmx' => [
            'name' => 'ASP',
            'group' => null,
            'color' => '#6a40fd',
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'aspx' => [
            'name' => 'ASP',
            'group' => null,
            'color' => '#6a40fd',
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'axd' => [
            'name' => 'ASP',
            'group' => null,
            'color' => '#6a40fd',
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'dats' => [
            'name' => 'ATS',
            'group' => null,
            'color' => '#1ac620',
            'ace' => 'ocaml',
            'cm' => null,
        ],
        'hats' => [
            'name' => 'ATS',
            'group' => null,
            'color' => '#1ac620',
            'ace' => 'ocaml',
            'cm' => null,
        ],
        'sats' => [
            'name' => 'ATS',
            'group' => null,
            'color' => '#1ac620',
            'ace' => 'ocaml',
            'cm' => null,
        ],
        'as' => [
            'name' => 'AngelScript',
            'group' => null,
            'color' => '#C7D7DC',
            'ace' => 'text',
            'cm' => 'clike',
        ],
        'adb' => [
            'name' => 'Ada',
            'group' => null,
            'color' => '#02f88c',
            'ace' => 'ada',
            'cm' => null,
        ],
        'ada' => [
            'name' => 'Ada',
            'group' => null,
            'color' => '#02f88c',
            'ace' => 'ada',
            'cm' => null,
        ],
        'ads' => [
            'name' => 'Ada',
            'group' => null,
            'color' => '#02f88c',
            'ace' => 'ada',
            'cm' => null,
        ],
        'afm' => [
            'name' => 'Adobe Font Metrics',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'agda' => [
            'name' => 'Agda',
            'group' => null,
            'color' => '#315665',
            'ace' => 'text',
            'cm' => null,
        ],
        'als' => [
            'name' => 'Alloy',
            'group' => null,
            'color' => '#64C800',
            'ace' => 'text',
            'cm' => null,
        ],
        'angelscript' => [
            'name' => 'AngelScript',
            'group' => null,
            'color' => '#C7D7DC',
            'ace' => 'text',
            'cm' => 'clike',
        ],
        'apacheconf' => [
            'name' => 'ApacheConf',
            'group' => null,
            'color' => null,
            'ace' => 'apache_conf',
            'cm' => null,
        ],
        'vhost' => [
            'name' => 'Nginx',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'nginx',
        ],
        'cls' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'agc' => [
            'name' => 'Apollo Guidance Computer',
            'group' => 'Assembly',
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'applescript' => [
            'name' => 'AppleScript',
            'group' => null,
            'color' => '#101F1F',
            'ace' => 'applescript',
            'cm' => null,
        ],
        'scpt' => [
            'name' => 'AppleScript',
            'group' => null,
            'color' => '#101F1F',
            'ace' => 'applescript',
            'cm' => null,
        ],
        'arc' => [
            'name' => 'Arc',
            'group' => null,
            'color' => '#aa2afe',
            'ace' => 'text',
            'cm' => null,
        ],
        'asciidoc' => [
            'name' => 'AsciiDoc',
            'group' => null,
            'color' => null,
            'ace' => 'asciidoc',
            'cm' => null,
        ],
        'adoc' => [
            'name' => 'AsciiDoc',
            'group' => null,
            'color' => null,
            'ace' => 'asciidoc',
            'cm' => null,
        ],
        'aj' => [
            'name' => 'AspectJ',
            'group' => null,
            'color' => '#a957b0',
            'ace' => 'text',
            'cm' => null,
        ],
        'asm' => [
            'name' => 'Assembly',
            'group' => null,
            'color' => '#6E4C13',
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'a51' => [
            'name' => 'Assembly',
            'group' => null,
            'color' => '#6E4C13',
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'inc' => [
            'name' => 'SourcePawn',
            'group' => null,
            'color' => '#5c7611',
            'ace' => 'text',
            'cm' => null,
        ],
        'nasm' => [
            'name' => 'Assembly',
            'group' => null,
            'color' => '#6E4C13',
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'aug' => [
            'name' => 'Augeas',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ahk' => [
            'name' => 'AutoHotkey',
            'group' => null,
            'color' => '#6594b9',
            'ace' => 'autohotkey',
            'cm' => null,
        ],
        'ahkl' => [
            'name' => 'AutoHotkey',
            'group' => null,
            'color' => '#6594b9',
            'ace' => 'autohotkey',
            'cm' => null,
        ],
        'au3' => [
            'name' => 'AutoIt',
            'group' => null,
            'color' => '#1C3552',
            'ace' => 'autohotkey',
            'cm' => null,
        ],
        'awk' => [
            'name' => 'Awk',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'auk' => [
            'name' => 'Awk',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gawk' => [
            'name' => 'Awk',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'mawk' => [
            'name' => 'Awk',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'nawk' => [
            'name' => 'Awk',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'bal' => [
            'name' => 'Ballerina',
            'group' => null,
            'color' => '#FF5000',
            'ace' => 'text',
            'cm' => null,
        ],
        'bat' => [
            'name' => 'Batchfile',
            'group' => null,
            'color' => '#C1F12E',
            'ace' => 'batchfile',
            'cm' => null,
        ],
        'cmd' => [
            'name' => 'Batchfile',
            'group' => null,
            'color' => '#C1F12E',
            'ace' => 'batchfile',
            'cm' => null,
        ],
        'befunge' => [
            'name' => 'Befunge',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'bison' => [
            'name' => 'Bison',
            'group' => 'Yacc',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'bb' => [
            'name' => 'BlitzBasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'blade' => [
            'name' => 'Blade',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'blade.php' => [
            'name' => 'Blade',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'decls' => [
            'name' => 'BlitzBasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'bmx' => [
            'name' => 'BlitzMax',
            'group' => null,
            'color' => '#cd6400',
            'ace' => 'text',
            'cm' => null,
        ],
        'bsv' => [
            'name' => 'Bluespec',
            'group' => null,
            'color' => null,
            'ace' => 'verilog',
            'cm' => null,
        ],
        'boo' => [
            'name' => 'Boo',
            'group' => null,
            'color' => '#d4bec1',
            'ace' => 'text',
            'cm' => null,
        ],
        'b' => [
            'name' => 'Limbo',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'bf' => [
            'name' => 'HyPhy',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'brs' => [
            'name' => 'Brightscript',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'bro' => [
            'name' => 'Bro',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'c' => [
            'name' => 'C',
            'group' => null,
            'color' => '#555555',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'cats' => [
            'name' => 'C',
            'group' => null,
            'color' => '#555555',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'h' => [
            'name' => 'Objective-C',
            'group' => null,
            'color' => '#438eff',
            'ace' => 'objectivec',
            'cm' => 'clike',
        ],
        'idc' => [
            'name' => 'C',
            'group' => null,
            'color' => '#555555',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'cs' => [
            'name' => 'Smalltalk',
            'group' => null,
            'color' => '#596706',
            'ace' => 'text',
            'cm' => 'smalltalk',
        ],
        'cake' => [
            'name' => 'CoffeeScript',
            'group' => null,
            'color' => '#244776',
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        'cshtml' => [
            'name' => 'C#',
            'group' => null,
            'color' => '#178600',
            'ace' => 'csharp',
            'cm' => 'clike',
        ],
        'csx' => [
            'name' => 'C#',
            'group' => null,
            'color' => '#178600',
            'ace' => 'csharp',
            'cm' => 'clike',
        ],
        'cpp' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'c++' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'cc' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'cp' => [
            'name' => 'Component Pascal',
            'group' => null,
            'color' => '#B0CE4E',
            'ace' => 'pascal',
            'cm' => 'pascal',
        ],
        'cxx' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'h++' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'hh' => [
            'name' => 'Hack',
            'group' => null,
            'color' => '#878787',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'hpp' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'hxx' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'inl' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'ino' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'ipp' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        're' => [
            'name' => 'Reason',
            'group' => 'OCaml',
            'color' => null,
            'ace' => 'rust',
            'cm' => 'rust',
        ],
        'tcc' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'tpp' => [
            'name' => 'C++',
            'group' => null,
            'color' => '#f34b7d',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'c-objdump' => [
            'name' => 'C-ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'chs' => [
            'name' => 'C2hs Haskell',
            'group' => 'Haskell',
            'color' => null,
            'ace' => 'haskell',
            'cm' => 'haskell',
        ],
        'clp' => [
            'name' => 'CLIPS',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'cmake' => [
            'name' => 'CMake',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'cmake',
        ],
        'cmake.in' => [
            'name' => 'CMake',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'cmake',
        ],
        'cob' => [
            'name' => 'COBOL',
            'group' => null,
            'color' => null,
            'ace' => 'cobol',
            'cm' => 'cobol',
        ],
        'cbl' => [
            'name' => 'COBOL',
            'group' => null,
            'color' => null,
            'ace' => 'cobol',
            'cm' => 'cobol',
        ],
        'ccp' => [
            'name' => 'COBOL',
            'group' => null,
            'color' => null,
            'ace' => 'cobol',
            'cm' => 'cobol',
        ],
        'cobol' => [
            'name' => 'COBOL',
            'group' => null,
            'color' => null,
            'ace' => 'cobol',
            'cm' => 'cobol',
        ],
        'cpy' => [
            'name' => 'COBOL',
            'group' => null,
            'color' => null,
            'ace' => 'cobol',
            'cm' => 'cobol',
        ],
        'dae' => [
            'name' => 'COLLADA',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'cson' => [
            'name' => 'CSON',
            'group' => 'CoffeeScript',
            'color' => null,
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        'css' => [
            'name' => 'CSS',
            'group' => null,
            'color' => '#563d7c',
            'ace' => 'css',
            'cm' => 'css',
        ],
        'csv' => [
            'name' => 'CSV',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'w' => [
            'name' => 'OpenEdge ABL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'capnp' => [
            'name' => 'Cap\'n Proto',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'mss' => [
            'name' => 'CartoCSS',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ceylon' => [
            'name' => 'Ceylon',
            'group' => null,
            'color' => '#dfa535',
            'ace' => 'text',
            'cm' => null,
        ],
        'chpl' => [
            'name' => 'Chapel',
            'group' => null,
            'color' => '#8dc63f',
            'ace' => 'text',
            'cm' => null,
        ],
        'ch' => [
            'name' => 'xBase',
            'group' => null,
            'color' => '#403a40',
            'ace' => 'text',
            'cm' => null,
        ],
        'ck' => [
            'name' => 'ChucK',
            'group' => null,
            'color' => null,
            'ace' => 'java',
            'cm' => 'clike',
        ],
        'cirru' => [
            'name' => 'Cirru',
            'group' => null,
            'color' => '#ccccff',
            'ace' => 'cirru',
            'cm' => null,
        ],
        'clw' => [
            'name' => 'Clarion',
            'group' => null,
            'color' => '#db901e',
            'ace' => 'text',
            'cm' => null,
        ],
        'icl' => [
            'name' => 'Clean',
            'group' => null,
            'color' => '#3F85AF',
            'ace' => 'text',
            'cm' => null,
        ],
        'dcl' => [
            'name' => 'Clean',
            'group' => null,
            'color' => '#3F85AF',
            'ace' => 'text',
            'cm' => null,
        ],
        'click' => [
            'name' => 'Click',
            'group' => null,
            'color' => '#E4E6F3',
            'ace' => 'text',
            'cm' => null,
        ],
        'clj' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'boot' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'cl2' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'cljc' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'cljs' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'cljs.hl' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'cljscm' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'cljx' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'hic' => [
            'name' => 'Clojure',
            'group' => null,
            'color' => '#db5855',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'soy' => [
            'name' => 'Closure Templates',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'soy_template',
            'cm' => 'soy',
        ],
        'conllu' => [
            'name' => 'CoNLL-U',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'conll' => [
            'name' => 'CoNLL-U',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'coffee' => [
            'name' => 'CoffeeScript',
            'group' => null,
            'color' => '#244776',
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        '_coffee' => [
            'name' => 'CoffeeScript',
            'group' => null,
            'color' => '#244776',
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        'cjsx' => [
            'name' => 'CoffeeScript',
            'group' => null,
            'color' => '#244776',
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        'iced' => [
            'name' => 'CoffeeScript',
            'group' => null,
            'color' => '#244776',
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        'cfm' => [
            'name' => 'ColdFusion',
            'group' => null,
            'color' => '#ed2cd6',
            'ace' => 'coldfusion',
            'cm' => null,
        ],
        'cfml' => [
            'name' => 'ColdFusion',
            'group' => null,
            'color' => '#ed2cd6',
            'ace' => 'coldfusion',
            'cm' => null,
        ],
        'cfc' => [
            'name' => 'ColdFusion CFC',
            'group' => 'ColdFusion',
            'color' => null,
            'ace' => 'coldfusion',
            'cm' => null,
        ],
        'lisp' => [
            'name' => 'NewLisp',
            'group' => null,
            'color' => '#87AED7',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'asd' => [
            'name' => 'Common Lisp',
            'group' => null,
            'color' => '#3fb68b',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'cl' => [
            'name' => 'OpenCL',
            'group' => 'C',
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'l' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'lsp' => [
            'name' => 'NewLisp',
            'group' => null,
            'color' => '#87AED7',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'ny' => [
            'name' => 'Common Lisp',
            'group' => null,
            'color' => '#3fb68b',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'podsl' => [
            'name' => 'Common Lisp',
            'group' => null,
            'color' => '#3fb68b',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'sexp' => [
            'name' => 'Common Lisp',
            'group' => null,
            'color' => '#3fb68b',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'cwl' => [
            'name' => 'Common Workflow Language',
            'group' => null,
            'color' => '#B5314C',
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'cps' => [
            'name' => 'Component Pascal',
            'group' => null,
            'color' => '#B0CE4E',
            'ace' => 'pascal',
            'cm' => 'pascal',
        ],
        'coq' => [
            'name' => 'Coq',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'v' => [
            'name' => 'Verilog',
            'group' => null,
            'color' => '#b2b7f8',
            'ace' => 'verilog',
            'cm' => 'verilog',
        ],
        'cppobjdump' => [
            'name' => 'Cpp-ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'c++-objdump' => [
            'name' => 'Cpp-ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'c++objdump' => [
            'name' => 'Cpp-ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'cpp-objdump' => [
            'name' => 'Cpp-ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'cxx-objdump' => [
            'name' => 'Cpp-ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'creole' => [
            'name' => 'Creole',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'cr' => [
            'name' => 'Crystal',
            'group' => null,
            'color' => '#776791',
            'ace' => 'ruby',
            'cm' => 'crystal',
        ],
        'orc' => [
            'name' => 'Csound',
            'group' => null,
            'color' => null,
            'ace' => 'csound_orchestra',
            'cm' => null,
        ],
        'udo' => [
            'name' => 'Csound',
            'group' => null,
            'color' => null,
            'ace' => 'csound_orchestra',
            'cm' => null,
        ],
        'csd' => [
            'name' => 'Csound Document',
            'group' => null,
            'color' => null,
            'ace' => 'csound_document',
            'cm' => null,
        ],
        'sco' => [
            'name' => 'Csound Score',
            'group' => null,
            'color' => null,
            'ace' => 'csound_score',
            'cm' => null,
        ],
        'cu' => [
            'name' => 'Cuda',
            'group' => null,
            'color' => '#3A4E3A',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'cuh' => [
            'name' => 'Cuda',
            'group' => null,
            'color' => '#3A4E3A',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'cy' => [
            'name' => 'Cycript',
            'group' => null,
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'pyx' => [
            'name' => 'Cython',
            'group' => 'Python',
            'color' => null,
            'ace' => 'text',
            'cm' => 'python',
        ],
        'pxd' => [
            'name' => 'Cython',
            'group' => 'Python',
            'color' => null,
            'ace' => 'text',
            'cm' => 'python',
        ],
        'pxi' => [
            'name' => 'Cython',
            'group' => 'Python',
            'color' => null,
            'ace' => 'text',
            'cm' => 'python',
        ],
        'd' => [
            'name' => 'Makefile',
            'group' => null,
            'color' => '#427819',
            'ace' => 'makefile',
            'cm' => 'cmake',
        ],
        'di' => [
            'name' => 'D',
            'group' => null,
            'color' => '#ba595e',
            'ace' => 'd',
            'cm' => 'd',
        ],
        'd-objdump' => [
            'name' => 'D-ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'com' => [
            'name' => 'DIGITAL Command Language',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'dm' => [
            'name' => 'DM',
            'group' => null,
            'color' => '#447265',
            'ace' => 'c_cpp',
            'cm' => null,
        ],
        'zone' => [
            'name' => 'DNS Zone',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'arpa' => [
            'name' => 'DNS Zone',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'darcspatch' => [
            'name' => 'Darcs Patch',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'dpatch' => [
            'name' => 'Darcs Patch',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'dart' => [
            'name' => 'Dart',
            'group' => null,
            'color' => '#00B4AB',
            'ace' => 'dart',
            'cm' => 'dart',
        ],
        'dwl' => [
            'name' => 'DataWeave',
            'group' => null,
            'color' => '#003a52',
            'ace' => 'text',
            'cm' => null,
        ],
        'diff' => [
            'name' => 'Diff',
            'group' => null,
            'color' => null,
            'ace' => 'diff',
            'cm' => 'diff',
        ],
        'patch' => [
            'name' => 'Diff',
            'group' => null,
            'color' => null,
            'ace' => 'diff',
            'cm' => 'diff',
        ],
        'dockerfile' => [
            'name' => 'Dockerfile',
            'group' => null,
            'color' => null,
            'ace' => 'dockerfile',
            'cm' => 'dockerfile',
        ],
        'djs' => [
            'name' => 'Dogescript',
            'group' => null,
            'color' => '#cca760',
            'ace' => 'text',
            'cm' => null,
        ],
        'dylan' => [
            'name' => 'Dylan',
            'group' => null,
            'color' => '#6c616e',
            'ace' => 'text',
            'cm' => 'dylan',
        ],
        'dyl' => [
            'name' => 'Dylan',
            'group' => null,
            'color' => '#6c616e',
            'ace' => 'text',
            'cm' => 'dylan',
        ],
        'intr' => [
            'name' => 'Dylan',
            'group' => null,
            'color' => '#6c616e',
            'ace' => 'text',
            'cm' => 'dylan',
        ],
        'lid' => [
            'name' => 'Dylan',
            'group' => null,
            'color' => '#6c616e',
            'ace' => 'text',
            'cm' => 'dylan',
        ],
        'E' => [
            'name' => 'E',
            'group' => null,
            'color' => '#ccce35',
            'ace' => 'text',
            'cm' => null,
        ],
        'ebnf' => [
            'name' => 'EBNF',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'ebnf',
        ],
        'ecl' => [
            'name' => 'ECLiPSe',
            'group' => 'prolog',
            'color' => null,
            'ace' => 'prolog',
            'cm' => null,
        ],
        'eclxml' => [
            'name' => 'ECL',
            'group' => null,
            'color' => '#8a1267',
            'ace' => 'text',
            'cm' => 'ecl',
        ],
        'ejs' => [
            'name' => 'EJS',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'ejs',
            'cm' => null,
        ],
        'eq' => [
            'name' => 'EQ',
            'group' => null,
            'color' => '#a78649',
            'ace' => 'csharp',
            'cm' => 'clike',
        ],
        'sch' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'brd' => [
            'name' => 'KiCad Legacy Layout',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'eb' => [
            'name' => 'Easybuild',
            'group' => 'Python',
            'color' => null,
            'ace' => 'python',
            'cm' => 'python',
        ],
        'epj' => [
            'name' => 'Ecere Projects',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'edc' => [
            'name' => 'Edje Data Collection',
            'group' => null,
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'e' => [
            'name' => 'Eiffel',
            'group' => null,
            'color' => '#946d57',
            'ace' => 'eiffel',
            'cm' => 'eiffel',
        ],
        'ex' => [
            'name' => 'Elixir',
            'group' => null,
            'color' => '#6e4a7e',
            'ace' => 'elixir',
            'cm' => null,
        ],
        'exs' => [
            'name' => 'Elixir',
            'group' => null,
            'color' => '#6e4a7e',
            'ace' => 'elixir',
            'cm' => null,
        ],
        'elm' => [
            'name' => 'Elm',
            'group' => null,
            'color' => '#60B5CC',
            'ace' => 'elm',
            'cm' => 'elm',
        ],
        'el' => [
            'name' => 'Emacs Lisp',
            'group' => null,
            'color' => '#c065db',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'emacs' => [
            'name' => 'Emacs Lisp',
            'group' => null,
            'color' => '#c065db',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'emacs.desktop' => [
            'name' => 'Emacs Lisp',
            'group' => null,
            'color' => '#c065db',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'em' => [
            'name' => 'EmberScript',
            'group' => null,
            'color' => '#FFF4F3',
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        'emberscript' => [
            'name' => 'EmberScript',
            'group' => null,
            'color' => '#FFF4F3',
            'ace' => 'coffee',
            'cm' => 'coffeescript',
        ],
        'erl' => [
            'name' => 'Erlang',
            'group' => null,
            'color' => '#B83998',
            'ace' => 'erlang',
            'cm' => 'erlang',
        ],
        'app.src' => [
            'name' => 'Erlang',
            'group' => null,
            'color' => '#B83998',
            'ace' => 'erlang',
            'cm' => 'erlang',
        ],
        'es' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'escript' => [
            'name' => 'Erlang',
            'group' => null,
            'color' => '#B83998',
            'ace' => 'erlang',
            'cm' => 'erlang',
        ],
        'hrl' => [
            'name' => 'Erlang',
            'group' => null,
            'color' => '#B83998',
            'ace' => 'erlang',
            'cm' => 'erlang',
        ],
        'xrl' => [
            'name' => 'Erlang',
            'group' => null,
            'color' => '#B83998',
            'ace' => 'erlang',
            'cm' => 'erlang',
        ],
        'yrl' => [
            'name' => 'Erlang',
            'group' => null,
            'color' => '#B83998',
            'ace' => 'erlang',
            'cm' => 'erlang',
        ],
        'fs' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'fsi' => [
            'name' => 'F#',
            'group' => null,
            'color' => '#b845fc',
            'ace' => 'text',
            'cm' => 'mllike',
        ],
        'fsx' => [
            'name' => 'F#',
            'group' => null,
            'color' => '#b845fc',
            'ace' => 'text',
            'cm' => 'mllike',
        ],
        'fx' => [
            'name' => 'HLSL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'flux' => [
            'name' => 'FLUX',
            'group' => null,
            'color' => '#88ccff',
            'ace' => 'text',
            'cm' => null,
        ],
        'factor' => [
            'name' => 'Factor',
            'group' => null,
            'color' => '#636746',
            'ace' => 'text',
            'cm' => 'factor',
        ],
        'fy' => [
            'name' => 'Fancy',
            'group' => null,
            'color' => '#7b9db4',
            'ace' => 'text',
            'cm' => null,
        ],
        'fancypack' => [
            'name' => 'Fancy',
            'group' => null,
            'color' => '#7b9db4',
            'ace' => 'text',
            'cm' => null,
        ],
        'fan' => [
            'name' => 'Fantom',
            'group' => null,
            'color' => '#14253c',
            'ace' => 'text',
            'cm' => null,
        ],
        'f' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'for' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'eam.fs' => [
            'name' => 'Formatted',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'fth' => [
            'name' => 'Forth',
            'group' => null,
            'color' => '#341708',
            'ace' => 'forth',
            'cm' => 'forth',
        ],
        '4th' => [
            'name' => 'Forth',
            'group' => null,
            'color' => '#341708',
            'ace' => 'forth',
            'cm' => 'forth',
        ],
        'forth' => [
            'name' => 'Forth',
            'group' => null,
            'color' => '#341708',
            'ace' => 'forth',
            'cm' => 'forth',
        ],
        'fr' => [
            'name' => 'Text',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'frt' => [
            'name' => 'Forth',
            'group' => null,
            'color' => '#341708',
            'ace' => 'forth',
            'cm' => 'forth',
        ],
        'f90' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'f03' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'f08' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'f77' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'f95' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'fpp' => [
            'name' => 'Fortran',
            'group' => null,
            'color' => '#4d41b1',
            'ace' => 'text',
            'cm' => 'fortran',
        ],
        'ftl' => [
            'name' => 'FreeMarker',
            'group' => null,
            'color' => '#0050b2',
            'ace' => 'ftl',
            'cm' => null,
        ],
        'g' => [
            'name' => 'GAP',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gco' => [
            'name' => 'G-code',
            'group' => null,
            'color' => null,
            'ace' => 'gcode',
            'cm' => null,
        ],
        'gcode' => [
            'name' => 'G-code',
            'group' => null,
            'color' => null,
            'ace' => 'gcode',
            'cm' => null,
        ],
        'gms' => [
            'name' => 'GAMS',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gap' => [
            'name' => 'GAP',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gd' => [
            'name' => 'GDScript',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gi' => [
            'name' => 'GAP',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'tst' => [
            'name' => 'Scilab',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'md' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'gdb' => [
            'name' => 'GDB',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gdbinit' => [
            'name' => 'GDB',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'glsl' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'fp' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'frag' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'frg' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'fsh' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'fshader' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'geo' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'geom' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'glslv' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'gshader' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'shader' => [
            'name' => 'ShaderLab',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'tesc' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'tese' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'vert' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'vrx' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'vsh' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'vshader' => [
            'name' => 'GLSL',
            'group' => null,
            'color' => null,
            'ace' => 'glsl',
            'cm' => null,
        ],
        'gn' => [
            'name' => 'GN',
            'group' => null,
            'color' => null,
            'ace' => 'python',
            'cm' => 'python',
        ],
        'gni' => [
            'name' => 'GN',
            'group' => null,
            'color' => null,
            'ace' => 'python',
            'cm' => 'python',
        ],
        'gml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'gs' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'kid' => [
            'name' => 'Genshi',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ebuild' => [
            'name' => 'Gentoo Ebuild',
            'group' => 'Shell',
            'color' => null,
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'eclass' => [
            'name' => 'Gentoo Eclass',
            'group' => 'Shell',
            'color' => null,
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'gbr' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gbl' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gbo' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gbp' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gbs' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gko' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gpb' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gpt' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gtl' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gto' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gtp' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gts' => [
            'name' => 'Gerber Image',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'po' => [
            'name' => 'Gettext Catalog',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pot' => [
            'name' => 'Gettext Catalog',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'feature' => [
            'name' => 'Gherkin',
            'group' => null,
            'color' => '#5B2063',
            'ace' => 'text',
            'cm' => null,
        ],
        'glf' => [
            'name' => 'Glyph',
            'group' => null,
            'color' => '#e4cc98',
            'ace' => 'tcl',
            'cm' => 'tcl',
        ],
        'gp' => [
            'name' => 'Gnuplot',
            'group' => null,
            'color' => '#f0a9f0',
            'ace' => 'text',
            'cm' => null,
        ],
        'gnu' => [
            'name' => 'Gnuplot',
            'group' => null,
            'color' => '#f0a9f0',
            'ace' => 'text',
            'cm' => null,
        ],
        'gnuplot' => [
            'name' => 'Gnuplot',
            'group' => null,
            'color' => '#f0a9f0',
            'ace' => 'text',
            'cm' => null,
        ],
        'plot' => [
            'name' => 'Gnuplot',
            'group' => null,
            'color' => '#f0a9f0',
            'ace' => 'text',
            'cm' => null,
        ],
        'plt' => [
            'name' => 'Gnuplot',
            'group' => null,
            'color' => '#f0a9f0',
            'ace' => 'text',
            'cm' => null,
        ],
        'go' => [
            'name' => 'Go',
            'group' => null,
            'color' => '#375eab',
            'ace' => 'golang',
            'cm' => 'go',
        ],
        'golo' => [
            'name' => 'Golo',
            'group' => null,
            'color' => '#88562A',
            'ace' => 'text',
            'cm' => null,
        ],
        'gst' => [
            'name' => 'Gosu',
            'group' => null,
            'color' => '#82937f',
            'ace' => 'text',
            'cm' => null,
        ],
        'gsx' => [
            'name' => 'Gosu',
            'group' => null,
            'color' => '#82937f',
            'ace' => 'text',
            'cm' => null,
        ],
        'vark' => [
            'name' => 'Gosu',
            'group' => null,
            'color' => '#82937f',
            'ace' => 'text',
            'cm' => null,
        ],
        'grace' => [
            'name' => 'Grace',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gradle' => [
            'name' => 'Gradle',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gf' => [
            'name' => 'Grammatical Framework',
            'group' => null,
            'color' => '#79aa7a',
            'ace' => 'haskell',
            'cm' => 'haskell',
        ],
        'graphql' => [
            'name' => 'GraphQL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gql' => [
            'name' => 'GraphQL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'dot' => [
            'name' => 'Graphviz (DOT)',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'gv' => [
            'name' => 'Graphviz (DOT)',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'groovy' => [
            'name' => 'Groovy',
            'group' => null,
            'color' => '#e69f56',
            'ace' => 'groovy',
            'cm' => 'groovy',
        ],
        'grt' => [
            'name' => 'Groovy',
            'group' => null,
            'color' => '#e69f56',
            'ace' => 'groovy',
            'cm' => 'groovy',
        ],
        'gtpl' => [
            'name' => 'Groovy',
            'group' => null,
            'color' => '#e69f56',
            'ace' => 'groovy',
            'cm' => 'groovy',
        ],
        'gvy' => [
            'name' => 'Groovy',
            'group' => null,
            'color' => '#e69f56',
            'ace' => 'groovy',
            'cm' => 'groovy',
        ],
        'gsp' => [
            'name' => 'Groovy Server Pages',
            'group' => 'Groovy',
            'color' => null,
            'ace' => 'jsp',
            'cm' => 'htmlembedded',
        ],
        'hcl' => [
            'name' => 'HCL',
            'group' => null,
            'color' => null,
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'tf' => [
            'name' => 'HCL',
            'group' => null,
            'color' => null,
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'tfvars' => [
            'name' => 'HCL',
            'group' => null,
            'color' => null,
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'hlsl' => [
            'name' => 'HLSL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'cginc' => [
            'name' => 'HLSL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'fxh' => [
            'name' => 'HLSL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'hlsli' => [
            'name' => 'HLSL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'html' => [
            'name' => 'HTML',
            'group' => null,
            'color' => '#e34c26',
            'ace' => 'html',
            'cm' => 'htmlmixed',
        ],
        'htm' => [
            'name' => 'HTML',
            'group' => null,
            'color' => '#e34c26',
            'ace' => 'html',
            'cm' => 'htmlmixed',
        ],
        'html.hl' => [
            'name' => 'HTML',
            'group' => null,
            'color' => '#e34c26',
            'ace' => 'html',
            'cm' => 'htmlmixed',
        ],
        'st' => [
            'name' => 'Smalltalk',
            'group' => null,
            'color' => '#596706',
            'ace' => 'text',
            'cm' => 'smalltalk',
        ],
        'xht' => [
            'name' => 'HTML',
            'group' => null,
            'color' => '#e34c26',
            'ace' => 'html',
            'cm' => 'htmlmixed',
        ],
        'xhtml' => [
            'name' => 'HTML',
            'group' => null,
            'color' => '#e34c26',
            'ace' => 'html',
            'cm' => 'htmlmixed',
        ],
        'jinja' => [
            'name' => 'HTML+Django',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'django',
            'cm' => 'django',
        ],
        'jinja2' => [
            'name' => 'HTML+Django',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'django',
            'cm' => 'django',
        ],
        'mustache' => [
            'name' => 'HTML+Django',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'django',
            'cm' => 'django',
        ],
        'njk' => [
            'name' => 'HTML+Django',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'django',
            'cm' => 'django',
        ],
        'ecr' => [
            'name' => 'HTML+ECR',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => 'htmlmixed',
        ],
        'eex' => [
            'name' => 'HTML+EEX',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => 'htmlmixed',
        ],
        'erb' => [
            'name' => 'HTML+ERB',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'erb.deface' => [
            'name' => 'HTML+ERB',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => 'htmlembedded',
        ],
        'phtml' => [
            'name' => 'HTML+PHP',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'php',
            'cm' => 'php',
        ],
        'http' => [
            'name' => 'HTTP',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'http',
        ],
        'hxml' => [
            'name' => 'HXML',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'php' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'haml' => [
            'name' => 'Haml',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'haml',
            'cm' => 'haml',
        ],
        'haml.deface' => [
            'name' => 'Haml',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'haml',
            'cm' => 'haml',
        ],
        'handlebars' => [
            'name' => 'Handlebars',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'handlebars',
            'cm' => null,
        ],
        'hbs' => [
            'name' => 'Handlebars',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'handlebars',
            'cm' => null,
        ],
        'hb' => [
            'name' => 'Harbour',
            'group' => null,
            'color' => '#0e60e3',
            'ace' => 'text',
            'cm' => null,
        ],
        'hs' => [
            'name' => 'Haskell',
            'group' => null,
            'color' => '#5e5086',
            'ace' => 'haskell',
            'cm' => 'haskell',
        ],
        'hsc' => [
            'name' => 'Haskell',
            'group' => null,
            'color' => '#5e5086',
            'ace' => 'haskell',
            'cm' => 'haskell',
        ],
        'hx' => [
            'name' => 'Haxe',
            'group' => null,
            'color' => '#df7900',
            'ace' => 'haxe',
            'cm' => 'haxe',
        ],
        'hxsl' => [
            'name' => 'Haxe',
            'group' => null,
            'color' => '#df7900',
            'ace' => 'haxe',
            'cm' => 'haxe',
        ],
        'q' => [
            'name' => 'q',
            'group' => null,
            'color' => '#0040cd',
            'ace' => 'text',
            'cm' => null,
        ],
        'hy' => [
            'name' => 'Hy',
            'group' => null,
            'color' => '#7790B2',
            'ace' => 'text',
            'cm' => null,
        ],
        'pro' => [
            'name' => 'QMake',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'dlm' => [
            'name' => 'IDL',
            'group' => null,
            'color' => '#a3522f',
            'ace' => 'text',
            'cm' => 'idl',
        ],
        'ipf' => [
            'name' => 'IGOR Pro',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ini' => [
            'name' => 'INI',
            'group' => null,
            'color' => null,
            'ace' => 'ini',
            'cm' => 'properties',
        ],
        'cfg' => [
            'name' => 'INI',
            'group' => null,
            'color' => null,
            'ace' => 'ini',
            'cm' => 'properties',
        ],
        'prefs' => [
            'name' => 'INI',
            'group' => null,
            'color' => null,
            'ace' => 'ini',
            'cm' => 'properties',
        ],
        'properties' => [
            'name' => 'INI',
            'group' => null,
            'color' => null,
            'ace' => 'ini',
            'cm' => 'properties',
        ],
        'irclog' => [
            'name' => 'IRC log',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mirc',
        ],
        'weechatlog' => [
            'name' => 'IRC log',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mirc',
        ],
        'idr' => [
            'name' => 'Idris',
            'group' => null,
            'color' => '#b30000',
            'ace' => 'text',
            'cm' => null,
        ],
        'lidr' => [
            'name' => 'Idris',
            'group' => null,
            'color' => '#b30000',
            'ace' => 'text',
            'cm' => null,
        ],
        'ni' => [
            'name' => 'Inform 7',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'i7x' => [
            'name' => 'Inform 7',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'iss' => [
            'name' => 'Inno Setup',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'io' => [
            'name' => 'Io',
            'group' => null,
            'color' => '#a9188d',
            'ace' => 'io',
            'cm' => null,
        ],
        'ik' => [
            'name' => 'Ioke',
            'group' => null,
            'color' => '#078193',
            'ace' => 'text',
            'cm' => null,
        ],
        'thy' => [
            'name' => 'Isabelle',
            'group' => null,
            'color' => '#FEFE00',
            'ace' => 'text',
            'cm' => null,
        ],
        'ijs' => [
            'name' => 'J',
            'group' => null,
            'color' => '#9EEDFF',
            'ace' => 'text',
            'cm' => null,
        ],
        'flex' => [
            'name' => 'JFlex',
            'group' => 'Lex',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'jflex' => [
            'name' => 'JFlex',
            'group' => 'Lex',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'json' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'avsc' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'geojson' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'gltf' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'JSON-tmLanguage' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'jsonl' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'tfstate' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'tfstate.backup' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'topojson' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'webapp' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'webmanifest' => [
            'name' => 'JSON',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'json5' => [
            'name' => 'JSON5',
            'group' => null,
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jsonld' => [
            'name' => 'JSONLD',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'javascript',
            'cm' => null,
        ],
        'jq' => [
            'name' => 'JSONiq',
            'group' => null,
            'color' => '#40d47e',
            'ace' => 'jsoniq',
            'cm' => 'javascript',
        ],
        'jsx' => [
            'name' => 'JSX',
            'group' => 'JavaScript',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'jsx',
        ],
        'j' => [
            'name' => 'Objective-J',
            'group' => null,
            'color' => '#ff0c5a',
            'ace' => 'text',
            'cm' => null,
        ],
        'java' => [
            'name' => 'Java',
            'group' => null,
            'color' => '#b07219',
            'ace' => 'java',
            'cm' => 'clike',
        ],
        'jsp' => [
            'name' => 'Java Server Pages',
            'group' => 'Java',
            'color' => null,
            'ace' => 'jsp',
            'cm' => 'htmlembedded',
        ],
        'js' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        '_js' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'bones' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'es6' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jake' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jsb' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jscad' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jsfl' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jsm' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jss' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'mjs' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'njs' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'pac' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sjs' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'ssjs' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'xsjs' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'xsjslib' => [
            'name' => 'JavaScript',
            'group' => null,
            'color' => '#f1e05a',
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'jison' => [
            'name' => 'Jison',
            'group' => 'Yacc',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'jisonlex' => [
            'name' => 'Jison Lex',
            'group' => 'Lex',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ol' => [
            'name' => 'Jolie',
            'group' => null,
            'color' => '#843179',
            'ace' => 'text',
            'cm' => null,
        ],
        'iol' => [
            'name' => 'Jolie',
            'group' => null,
            'color' => '#843179',
            'ace' => 'text',
            'cm' => null,
        ],
        'jl' => [
            'name' => 'Julia',
            'group' => null,
            'color' => '#a270ba',
            'ace' => 'julia',
            'cm' => 'julia',
        ],
        'ipynb' => [
            'name' => 'Jupyter Notebook',
            'group' => null,
            'color' => '#DA5B0B',
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'krl' => [
            'name' => 'KRL',
            'group' => null,
            'color' => '#28431f',
            'ace' => 'text',
            'cm' => null,
        ],
        'kicad_pcb' => [
            'name' => 'KiCad Layout',
            'group' => null,
            'color' => null,
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'kicad_mod' => [
            'name' => 'KiCad Layout',
            'group' => null,
            'color' => null,
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'kicad_wks' => [
            'name' => 'KiCad Layout',
            'group' => null,
            'color' => null,
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'kit' => [
            'name' => 'Kit',
            'group' => null,
            'color' => null,
            'ace' => 'html',
            'cm' => 'htmlmixed',
        ],
        'kt' => [
            'name' => 'Kotlin',
            'group' => null,
            'color' => '#F18E33',
            'ace' => 'text',
            'cm' => 'clike',
        ],
        'ktm' => [
            'name' => 'Kotlin',
            'group' => null,
            'color' => '#F18E33',
            'ace' => 'text',
            'cm' => 'clike',
        ],
        'kts' => [
            'name' => 'Kotlin',
            'group' => null,
            'color' => '#F18E33',
            'ace' => 'text',
            'cm' => 'clike',
        ],
        'lfe' => [
            'name' => 'LFE',
            'group' => null,
            'color' => '#4C3023',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'll' => [
            'name' => 'LLVM',
            'group' => null,
            'color' => '#185619',
            'ace' => 'text',
            'cm' => null,
        ],
        'lol' => [
            'name' => 'LOLCODE',
            'group' => null,
            'color' => '#cc9900',
            'ace' => 'text',
            'cm' => null,
        ],
        'lsl' => [
            'name' => 'LSL',
            'group' => null,
            'color' => '#3d9970',
            'ace' => 'lsl',
            'cm' => null,
        ],
        'lslp' => [
            'name' => 'LSL',
            'group' => null,
            'color' => '#3d9970',
            'ace' => 'lsl',
            'cm' => null,
        ],
        'lvproj' => [
            'name' => 'LabVIEW',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'lasso' => [
            'name' => 'Lasso',
            'group' => null,
            'color' => '#999999',
            'ace' => 'text',
            'cm' => null,
        ],
        'las' => [
            'name' => 'Lasso',
            'group' => null,
            'color' => '#999999',
            'ace' => 'text',
            'cm' => null,
        ],
        'lasso8' => [
            'name' => 'Lasso',
            'group' => null,
            'color' => '#999999',
            'ace' => 'text',
            'cm' => null,
        ],
        'lasso9' => [
            'name' => 'Lasso',
            'group' => null,
            'color' => '#999999',
            'ace' => 'text',
            'cm' => null,
        ],
        'ldml' => [
            'name' => 'Lasso',
            'group' => null,
            'color' => '#999999',
            'ace' => 'text',
            'cm' => null,
        ],
        'latte' => [
            'name' => 'Latte',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'smarty',
            'cm' => 'smarty',
        ],
        'lean' => [
            'name' => 'Lean',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'hlean' => [
            'name' => 'Lean',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'less' => [
            'name' => 'Less',
            'group' => 'CSS',
            'color' => null,
            'ace' => 'less',
            'cm' => 'css',
        ],
        'lex' => [
            'name' => 'Lex',
            'group' => null,
            'color' => '#DBCA00',
            'ace' => 'text',
            'cm' => null,
        ],
        'ly' => [
            'name' => 'LilyPond',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ily' => [
            'name' => 'LilyPond',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'm' => [
            'name' => 'Objective-C',
            'group' => null,
            'color' => '#438eff',
            'ace' => 'objectivec',
            'cm' => 'clike',
        ],
        'ld' => [
            'name' => 'Linker Script',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'lds' => [
            'name' => 'Linker Script',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'x' => [
            'name' => 'RPC',
            'group' => null,
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => null,
        ],
        'liquid' => [
            'name' => 'Liquid',
            'group' => null,
            'color' => null,
            'ace' => 'liquid',
            'cm' => null,
        ],
        'lagda' => [
            'name' => 'Literate Agda',
            'group' => 'Agda',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'litcoffee' => [
            'name' => 'Literate CoffeeScript',
            'group' => 'CoffeeScript',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'lhs' => [
            'name' => 'Literate Haskell',
            'group' => 'Haskell',
            'color' => null,
            'ace' => 'text',
            'cm' => 'haskell-literate',
        ],
        'ls' => [
            'name' => 'LoomScript',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        '_ls' => [
            'name' => 'LiveScript',
            'group' => null,
            'color' => '#499886',
            'ace' => 'livescript',
            'cm' => 'livescript',
        ],
        'xm' => [
            'name' => 'Logos',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'xi' => [
            'name' => 'Logos',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'lgt' => [
            'name' => 'Logtalk',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'logtalk' => [
            'name' => 'Logtalk',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'lookml' => [
            'name' => 'LookML',
            'group' => null,
            'color' => '#652B81',
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'model.lkml' => [
            'name' => 'LookML',
            'group' => null,
            'color' => '#652B81',
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'view.lkml' => [
            'name' => 'LookML',
            'group' => null,
            'color' => '#652B81',
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'lua' => [
            'name' => 'Lua',
            'group' => null,
            'color' => '#000080',
            'ace' => 'lua',
            'cm' => 'lua',
        ],
        'fcgi' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'nse' => [
            'name' => 'Lua',
            'group' => null,
            'color' => '#000080',
            'ace' => 'lua',
            'cm' => 'lua',
        ],
        'p8' => [
            'name' => 'Lua',
            'group' => null,
            'color' => '#000080',
            'ace' => 'lua',
            'cm' => 'lua',
        ],
        'pd_lua' => [
            'name' => 'Lua',
            'group' => null,
            'color' => '#000080',
            'ace' => 'lua',
            'cm' => 'lua',
        ],
        'rbxs' => [
            'name' => 'Lua',
            'group' => null,
            'color' => '#000080',
            'ace' => 'lua',
            'cm' => 'lua',
        ],
        'wlua' => [
            'name' => 'Lua',
            'group' => null,
            'color' => '#000080',
            'ace' => 'lua',
            'cm' => 'lua',
        ],
        'mumps' => [
            'name' => 'M',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mumps',
        ],
        'm4' => [
            'name' => 'M4Sugar',
            'group' => 'M4',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ms' => [
            'name' => 'Unix Assembly',
            'group' => 'Assembly',
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'mcr' => [
            'name' => 'MAXScript',
            'group' => null,
            'color' => '#00a6a6',
            'ace' => 'text',
            'cm' => null,
        ],
        'mq4' => [
            'name' => 'MQL4',
            'group' => null,
            'color' => '#62A8D6',
            'ace' => 'c_cpp',
            'cm' => null,
        ],
        'mqh' => [
            'name' => 'MQL5',
            'group' => null,
            'color' => '#4A76B8',
            'ace' => 'c_cpp',
            'cm' => null,
        ],
        'mq5' => [
            'name' => 'MQL5',
            'group' => null,
            'color' => '#4A76B8',
            'ace' => 'c_cpp',
            'cm' => null,
        ],
        'mtml' => [
            'name' => 'MTML',
            'group' => null,
            'color' => '#b7e1f4',
            'ace' => 'html',
            'cm' => 'htmlmixed',
        ],
        'muf' => [
            'name' => 'MUF',
            'group' => 'Forth',
            'color' => null,
            'ace' => 'forth',
            'cm' => 'forth',
        ],
        'mak' => [
            'name' => 'Makefile',
            'group' => null,
            'color' => '#427819',
            'ace' => 'makefile',
            'cm' => 'cmake',
        ],
        'make' => [
            'name' => 'Makefile',
            'group' => null,
            'color' => '#427819',
            'ace' => 'makefile',
            'cm' => 'cmake',
        ],
        'mk' => [
            'name' => 'Makefile',
            'group' => null,
            'color' => '#427819',
            'ace' => 'makefile',
            'cm' => 'cmake',
        ],
        'mkfile' => [
            'name' => 'Makefile',
            'group' => null,
            'color' => '#427819',
            'ace' => 'makefile',
            'cm' => 'cmake',
        ],
        'mako' => [
            'name' => 'Mako',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'mao' => [
            'name' => 'Mako',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'markdown' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'mdown' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'mdwn' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'mkd' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'mkdn' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'mkdown' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'ronn' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'workbook' => [
            'name' => 'Markdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'marko' => [
            'name' => 'Marko',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => 'htmlmixed',
        ],
        'mask' => [
            'name' => 'Mask',
            'group' => null,
            'color' => '#f97732',
            'ace' => 'mask',
            'cm' => null,
        ],
        'mathematica' => [
            'name' => 'Mathematica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mathematica',
        ],
        'cdf' => [
            'name' => 'Mathematica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mathematica',
        ],
        'ma' => [
            'name' => 'Mathematica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mathematica',
        ],
        'mt' => [
            'name' => 'Mathematica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mathematica',
        ],
        'nb' => [
            'name' => 'Text',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'nbp' => [
            'name' => 'Mathematica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mathematica',
        ],
        'wl' => [
            'name' => 'Mathematica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mathematica',
        ],
        'wlt' => [
            'name' => 'Mathematica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'mathematica',
        ],
        'matlab' => [
            'name' => 'Matlab',
            'group' => null,
            'color' => '#e16737',
            'ace' => 'matlab',
            'cm' => 'octave',
        ],
        'maxpat' => [
            'name' => 'Max',
            'group' => null,
            'color' => '#c4a79c',
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'maxhelp' => [
            'name' => 'Max',
            'group' => null,
            'color' => '#c4a79c',
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'maxproj' => [
            'name' => 'Max',
            'group' => null,
            'color' => '#c4a79c',
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'mxt' => [
            'name' => 'Max',
            'group' => null,
            'color' => '#c4a79c',
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'pat' => [
            'name' => 'Max',
            'group' => null,
            'color' => '#c4a79c',
            'ace' => 'json',
            'cm' => 'javascript',
        ],
        'mediawiki' => [
            'name' => 'MediaWiki',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'wiki' => [
            'name' => 'MediaWiki',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'moo' => [
            'name' => 'Moocode',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'metal' => [
            'name' => 'Metal',
            'group' => null,
            'color' => '#8f14e9',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'minid' => [
            'name' => 'MiniD',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'druby' => [
            'name' => 'Mirah',
            'group' => null,
            'color' => '#c7a938',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'duby' => [
            'name' => 'Mirah',
            'group' => null,
            'color' => '#c7a938',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'mirah' => [
            'name' => 'Mirah',
            'group' => null,
            'color' => '#c7a938',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'mo' => [
            'name' => 'Modelica',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'modelica',
        ],
        'mms' => [
            'name' => 'Module Management System',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'mmk' => [
            'name' => 'Module Management System',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'monkey' => [
            'name' => 'Monkey',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'monkey2' => [
            'name' => 'Monkey',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'moon' => [
            'name' => 'MoonScript',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'myt' => [
            'name' => 'Myghty',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ncl' => [
            'name' => 'Text',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'nl' => [
            'name' => 'NewLisp',
            'group' => null,
            'color' => '#87AED7',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'nsi' => [
            'name' => 'NSIS',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'nsis',
        ],
        'nsh' => [
            'name' => 'NSIS',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'nsis',
        ],
        'ne' => [
            'name' => 'Nearley',
            'group' => null,
            'color' => '#990000',
            'ace' => 'text',
            'cm' => null,
        ],
        'nearley' => [
            'name' => 'Nearley',
            'group' => null,
            'color' => '#990000',
            'ace' => 'text',
            'cm' => null,
        ],
        'n' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'axs' => [
            'name' => 'NetLinx',
            'group' => null,
            'color' => '#0aa0ff',
            'ace' => 'text',
            'cm' => null,
        ],
        'axi' => [
            'name' => 'NetLinx',
            'group' => null,
            'color' => '#0aa0ff',
            'ace' => 'text',
            'cm' => null,
        ],
        'axs.erb' => [
            'name' => 'NetLinx+ERB',
            'group' => null,
            'color' => '#747faa',
            'ace' => 'text',
            'cm' => null,
        ],
        'axi.erb' => [
            'name' => 'NetLinx+ERB',
            'group' => null,
            'color' => '#747faa',
            'ace' => 'text',
            'cm' => null,
        ],
        'nlogo' => [
            'name' => 'NetLogo',
            'group' => null,
            'color' => '#ff6375',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'nf' => [
            'name' => 'Nextflow',
            'group' => null,
            'color' => '#3ac486',
            'ace' => 'groovy',
            'cm' => null,
        ],
        'nginxconf' => [
            'name' => 'Nginx',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'nginx',
        ],
        'nim' => [
            'name' => 'Nim',
            'group' => null,
            'color' => '#37775b',
            'ace' => 'text',
            'cm' => null,
        ],
        'nimrod' => [
            'name' => 'Nim',
            'group' => null,
            'color' => '#37775b',
            'ace' => 'text',
            'cm' => null,
        ],
        'ninja' => [
            'name' => 'Ninja',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'nit' => [
            'name' => 'Nit',
            'group' => null,
            'color' => '#009917',
            'ace' => 'text',
            'cm' => null,
        ],
        'nix' => [
            'name' => 'Nix',
            'group' => null,
            'color' => '#7e7eff',
            'ace' => 'nix',
            'cm' => null,
        ],
        'nu' => [
            'name' => 'Nu',
            'group' => null,
            'color' => '#c9df40',
            'ace' => 'scheme',
            'cm' => 'scheme',
        ],
        'numpy' => [
            'name' => 'NumPy',
            'group' => 'Python',
            'color' => null,
            'ace' => 'text',
            'cm' => 'python',
        ],
        'numpyw' => [
            'name' => 'NumPy',
            'group' => 'Python',
            'color' => null,
            'ace' => 'text',
            'cm' => 'python',
        ],
        'numsc' => [
            'name' => 'NumPy',
            'group' => 'Python',
            'color' => null,
            'ace' => 'text',
            'cm' => 'python',
        ],
        'ml' => [
            'name' => 'OCaml',
            'group' => null,
            'color' => '#3be133',
            'ace' => 'ocaml',
            'cm' => 'mllike',
        ],
        'eliom' => [
            'name' => 'OCaml',
            'group' => null,
            'color' => '#3be133',
            'ace' => 'ocaml',
            'cm' => 'mllike',
        ],
        'eliomi' => [
            'name' => 'OCaml',
            'group' => null,
            'color' => '#3be133',
            'ace' => 'ocaml',
            'cm' => 'mllike',
        ],
        'ml4' => [
            'name' => 'OCaml',
            'group' => null,
            'color' => '#3be133',
            'ace' => 'ocaml',
            'cm' => 'mllike',
        ],
        'mli' => [
            'name' => 'OCaml',
            'group' => null,
            'color' => '#3be133',
            'ace' => 'ocaml',
            'cm' => 'mllike',
        ],
        'mll' => [
            'name' => 'OCaml',
            'group' => null,
            'color' => '#3be133',
            'ace' => 'ocaml',
            'cm' => 'mllike',
        ],
        'mly' => [
            'name' => 'OCaml',
            'group' => null,
            'color' => '#3be133',
            'ace' => 'ocaml',
            'cm' => 'mllike',
        ],
        'objdump' => [
            'name' => 'ObjDump',
            'group' => null,
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'mm' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'sj' => [
            'name' => 'Objective-J',
            'group' => null,
            'color' => '#ff0c5a',
            'ace' => 'text',
            'cm' => null,
        ],
        'omgrofl' => [
            'name' => 'Omgrofl',
            'group' => null,
            'color' => '#cabbff',
            'ace' => 'text',
            'cm' => null,
        ],
        'opa' => [
            'name' => 'Opa',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'opal' => [
            'name' => 'Opal',
            'group' => null,
            'color' => '#f7ede0',
            'ace' => 'text',
            'cm' => null,
        ],
        'opencl' => [
            'name' => 'OpenCL',
            'group' => 'C',
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'p' => [
            'name' => 'OpenEdge ABL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'scad' => [
            'name' => 'OpenSCAD',
            'group' => null,
            'color' => null,
            'ace' => 'scad',
            'cm' => null,
        ],
        'fea' => [
            'name' => 'OpenType Feature File',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'org' => [
            'name' => 'Org',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ox' => [
            'name' => 'Ox',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'oxh' => [
            'name' => 'Ox',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'oxo' => [
            'name' => 'Ox',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'oxygene' => [
            'name' => 'Oxygene',
            'group' => null,
            'color' => '#cdd0e3',
            'ace' => 'text',
            'cm' => null,
        ],
        'oz' => [
            'name' => 'Oz',
            'group' => null,
            'color' => '#fab738',
            'ace' => 'text',
            'cm' => 'oz',
        ],
        'p4' => [
            'name' => 'P4',
            'group' => null,
            'color' => '#7055b5',
            'ace' => 'text',
            'cm' => null,
        ],
        'pwn' => [
            'name' => 'PAWN',
            'group' => null,
            'color' => '#dbb284',
            'ace' => 'text',
            'cm' => null,
        ],
        'aw' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'ctp' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'php3' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'php4' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'php5' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'phps' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'phpt' => [
            'name' => 'PHP',
            'group' => null,
            'color' => '#4F5D95',
            'ace' => 'php',
            'cm' => 'php',
        ],
        'pls' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'bdy' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'ddl' => [
            'name' => 'SQL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'fnc' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'pck' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'pkb' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'pks' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'plb' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'plsql' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'prc' => [
            'name' => 'SQL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'spc' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'sql' => [
            'name' => 'SQLPL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'tpb' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'tps' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'trg' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'vw' => [
            'name' => 'PLSQL',
            'group' => null,
            'color' => '#dad8d8',
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'pov' => [
            'name' => 'POV-Ray SDL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pan' => [
            'name' => 'Pan',
            'group' => null,
            'color' => '#cc0000',
            'ace' => 'text',
            'cm' => null,
        ],
        'psc' => [
            'name' => 'Papyrus',
            'group' => null,
            'color' => '#6600cc',
            'ace' => 'text',
            'cm' => null,
        ],
        'parrot' => [
            'name' => 'Parrot',
            'group' => null,
            'color' => '#f3ca0a',
            'ace' => 'text',
            'cm' => null,
        ],
        'pasm' => [
            'name' => 'Parrot Assembly',
            'group' => 'Parrot',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pir' => [
            'name' => 'Parrot Internal Representation',
            'group' => 'Parrot',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pas' => [
            'name' => 'Pascal',
            'group' => null,
            'color' => '#E3F171',
            'ace' => 'pascal',
            'cm' => 'pascal',
        ],
        'dfm' => [
            'name' => 'Pascal',
            'group' => null,
            'color' => '#E3F171',
            'ace' => 'pascal',
            'cm' => 'pascal',
        ],
        'dpr' => [
            'name' => 'Pascal',
            'group' => null,
            'color' => '#E3F171',
            'ace' => 'pascal',
            'cm' => 'pascal',
        ],
        'lpr' => [
            'name' => 'Pascal',
            'group' => null,
            'color' => '#E3F171',
            'ace' => 'pascal',
            'cm' => 'pascal',
        ],
        'pascal' => [
            'name' => 'Pascal',
            'group' => null,
            'color' => '#E3F171',
            'ace' => 'pascal',
            'cm' => 'pascal',
        ],
        'pp' => [
            'name' => 'Puppet',
            'group' => null,
            'color' => '#302B6D',
            'ace' => 'text',
            'cm' => 'puppet',
        ],
        'pep' => [
            'name' => 'Pep8',
            'group' => null,
            'color' => '#C76F5B',
            'ace' => 'text',
            'cm' => null,
        ],
        'pl' => [
            'name' => 'Prolog',
            'group' => null,
            'color' => '#74283c',
            'ace' => 'prolog',
            'cm' => null,
        ],
        'al' => [
            'name' => 'Perl',
            'group' => null,
            'color' => '#0298c3',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'cgi' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'perl' => [
            'name' => 'Perl',
            'group' => null,
            'color' => '#0298c3',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'ph' => [
            'name' => 'Perl',
            'group' => null,
            'color' => '#0298c3',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'plx' => [
            'name' => 'Perl',
            'group' => null,
            'color' => '#0298c3',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'pm' => [
            'name' => 'X PixMap',
            'group' => 'C',
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'psgi' => [
            'name' => 'Perl',
            'group' => null,
            'color' => '#0298c3',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        't' => [
            'name' => 'Turing',
            'group' => null,
            'color' => '#cf142b',
            'ace' => 'text',
            'cm' => null,
        ],
        '6pl' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        '6pm' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'nqp' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'p6' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'p6l' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'p6m' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'pl6' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'pm6' => [
            'name' => 'Perl 6',
            'group' => null,
            'color' => '#0000fb',
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'pic' => [
            'name' => 'Pic',
            'group' => 'Roff',
            'color' => null,
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'chem' => [
            'name' => 'Pic',
            'group' => 'Roff',
            'color' => null,
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'pkl' => [
            'name' => 'Pickle',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pig' => [
            'name' => 'PigLatin',
            'group' => null,
            'color' => '#fcd7de',
            'ace' => 'text',
            'cm' => null,
        ],
        'pike' => [
            'name' => 'Pike',
            'group' => null,
            'color' => '#005390',
            'ace' => 'text',
            'cm' => null,
        ],
        'pmod' => [
            'name' => 'Pike',
            'group' => null,
            'color' => '#005390',
            'ace' => 'text',
            'cm' => null,
        ],
        'pod' => [
            'name' => 'Pod',
            'group' => null,
            'color' => null,
            'ace' => 'perl',
            'cm' => 'perl',
        ],
        'pogo' => [
            'name' => 'PogoScript',
            'group' => null,
            'color' => '#d80074',
            'ace' => 'text',
            'cm' => null,
        ],
        'pony' => [
            'name' => 'Pony',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pcss' => [
            'name' => 'PostCSS',
            'group' => 'CSS',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ps' => [
            'name' => 'PostScript',
            'group' => null,
            'color' => '#da291c',
            'ace' => 'text',
            'cm' => null,
        ],
        'eps' => [
            'name' => 'PostScript',
            'group' => null,
            'color' => '#da291c',
            'ace' => 'text',
            'cm' => null,
        ],
        'pfa' => [
            'name' => 'PostScript',
            'group' => null,
            'color' => '#da291c',
            'ace' => 'text',
            'cm' => null,
        ],
        'pbt' => [
            'name' => 'PowerBuilder',
            'group' => null,
            'color' => '#8f0f8d',
            'ace' => 'text',
            'cm' => null,
        ],
        'sra' => [
            'name' => 'PowerBuilder',
            'group' => null,
            'color' => '#8f0f8d',
            'ace' => 'text',
            'cm' => null,
        ],
        'sru' => [
            'name' => 'PowerBuilder',
            'group' => null,
            'color' => '#8f0f8d',
            'ace' => 'text',
            'cm' => null,
        ],
        'srw' => [
            'name' => 'PowerBuilder',
            'group' => null,
            'color' => '#8f0f8d',
            'ace' => 'text',
            'cm' => null,
        ],
        'ps1' => [
            'name' => 'PowerShell',
            'group' => null,
            'color' => '#012456',
            'ace' => 'powershell',
            'cm' => 'powershell',
        ],
        'psd1' => [
            'name' => 'PowerShell',
            'group' => null,
            'color' => '#012456',
            'ace' => 'powershell',
            'cm' => 'powershell',
        ],
        'psm1' => [
            'name' => 'PowerShell',
            'group' => null,
            'color' => '#012456',
            'ace' => 'powershell',
            'cm' => 'powershell',
        ],
        'pde' => [
            'name' => 'Processing',
            'group' => null,
            'color' => '#0096D8',
            'ace' => 'text',
            'cm' => null,
        ],
        'prolog' => [
            'name' => 'Prolog',
            'group' => null,
            'color' => '#74283c',
            'ace' => 'prolog',
            'cm' => null,
        ],
        'yap' => [
            'name' => 'Prolog',
            'group' => null,
            'color' => '#74283c',
            'ace' => 'prolog',
            'cm' => null,
        ],
        'spin' => [
            'name' => 'Propeller Spin',
            'group' => null,
            'color' => '#7fa2a7',
            'ace' => 'text',
            'cm' => null,
        ],
        'proto' => [
            'name' => 'Protocol Buffer',
            'group' => null,
            'color' => null,
            'ace' => 'protobuf',
            'cm' => 'protobuf',
        ],
        'pub' => [
            'name' => 'Public Key',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'asciiarmor',
        ],
        'jade' => [
            'name' => 'Pug',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'jade',
            'cm' => 'pug',
        ],
        'pug' => [
            'name' => 'Pug',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'jade',
            'cm' => 'pug',
        ],
        'pd' => [
            'name' => 'Pure Data',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pb' => [
            'name' => 'PureBasic',
            'group' => null,
            'color' => '#5a6986',
            'ace' => 'text',
            'cm' => null,
        ],
        'pbi' => [
            'name' => 'PureBasic',
            'group' => null,
            'color' => '#5a6986',
            'ace' => 'text',
            'cm' => null,
        ],
        'purs' => [
            'name' => 'PureScript',
            'group' => null,
            'color' => '#1D222D',
            'ace' => 'haskell',
            'cm' => 'haskell',
        ],
        'py' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'bzl' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'gyp' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'gypi' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'lmi' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'py3' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'pyde' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'pyi' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'pyp' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'pyt' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'pyw' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'rpy' => [
            'name' => 'Ren\'Py',
            'group' => null,
            'color' => '#ff7f7f',
            'ace' => 'python',
            'cm' => null,
        ],
        'spec' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'tac' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'wsgi' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'xpy' => [
            'name' => 'Python',
            'group' => null,
            'color' => '#3572A5',
            'ace' => 'python',
            'cm' => 'python',
        ],
        'pytb' => [
            'name' => 'Python traceback',
            'group' => 'Python',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'qml' => [
            'name' => 'QML',
            'group' => null,
            'color' => '#44a51c',
            'ace' => 'text',
            'cm' => null,
        ],
        'qbs' => [
            'name' => 'QML',
            'group' => null,
            'color' => '#44a51c',
            'ace' => 'text',
            'cm' => null,
        ],
        'pri' => [
            'name' => 'QMake',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'r' => [
            'name' => 'Rebol',
            'group' => null,
            'color' => '#358a5b',
            'ace' => 'text',
            'cm' => null,
        ],
        'rd' => [
            'name' => 'R',
            'group' => null,
            'color' => '#198CE7',
            'ace' => 'r',
            'cm' => 'r',
        ],
        'rsx' => [
            'name' => 'R',
            'group' => null,
            'color' => '#198CE7',
            'ace' => 'r',
            'cm' => 'r',
        ],
        'raml' => [
            'name' => 'RAML',
            'group' => null,
            'color' => '#77d9fb',
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'rdoc' => [
            'name' => 'RDoc',
            'group' => null,
            'color' => null,
            'ace' => 'rdoc',
            'cm' => null,
        ],
        'rbbas' => [
            'name' => 'REALbasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rbfrm' => [
            'name' => 'REALbasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rbmnu' => [
            'name' => 'REALbasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rbres' => [
            'name' => 'REALbasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rbtbar' => [
            'name' => 'REALbasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rbuistate' => [
            'name' => 'REALbasic',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rexx' => [
            'name' => 'REXX',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'pprx' => [
            'name' => 'REXX',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rex' => [
            'name' => 'REXX',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rhtml' => [
            'name' => 'RHTML',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'rhtml',
            'cm' => 'htmlembedded',
        ],
        'rmd' => [
            'name' => 'RMarkdown',
            'group' => null,
            'color' => null,
            'ace' => 'markdown',
            'cm' => 'gfm',
        ],
        'rnh' => [
            'name' => 'RUNOFF',
            'group' => null,
            'color' => '#665a4e',
            'ace' => 'text',
            'cm' => null,
        ],
        'rno' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'rkt' => [
            'name' => 'Racket',
            'group' => null,
            'color' => '#22228f',
            'ace' => 'lisp',
            'cm' => null,
        ],
        'rktd' => [
            'name' => 'Racket',
            'group' => null,
            'color' => '#22228f',
            'ace' => 'lisp',
            'cm' => null,
        ],
        'rktl' => [
            'name' => 'Racket',
            'group' => null,
            'color' => '#22228f',
            'ace' => 'lisp',
            'cm' => null,
        ],
        'scrbl' => [
            'name' => 'Racket',
            'group' => null,
            'color' => '#22228f',
            'ace' => 'lisp',
            'cm' => null,
        ],
        'rl' => [
            'name' => 'Ragel',
            'group' => null,
            'color' => '#9d5200',
            'ace' => 'text',
            'cm' => null,
        ],
        'rsc' => [
            'name' => 'Rascal',
            'group' => null,
            'color' => '#fffaa0',
            'ace' => 'text',
            'cm' => null,
        ],
        'raw' => [
            'name' => 'Raw token data',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rei' => [
            'name' => 'Reason',
            'group' => 'OCaml',
            'color' => null,
            'ace' => 'rust',
            'cm' => 'rust',
        ],
        'reb' => [
            'name' => 'Rebol',
            'group' => null,
            'color' => '#358a5b',
            'ace' => 'text',
            'cm' => null,
        ],
        'r2' => [
            'name' => 'Rebol',
            'group' => null,
            'color' => '#358a5b',
            'ace' => 'text',
            'cm' => null,
        ],
        'r3' => [
            'name' => 'Rebol',
            'group' => null,
            'color' => '#358a5b',
            'ace' => 'text',
            'cm' => null,
        ],
        'rebol' => [
            'name' => 'Rebol',
            'group' => null,
            'color' => '#358a5b',
            'ace' => 'text',
            'cm' => null,
        ],
        'red' => [
            'name' => 'Red',
            'group' => null,
            'color' => '#f50000',
            'ace' => 'text',
            'cm' => null,
        ],
        'reds' => [
            'name' => 'Red',
            'group' => null,
            'color' => '#f50000',
            'ace' => 'text',
            'cm' => null,
        ],
        'cw' => [
            'name' => 'Redcode',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'regexp' => [
            'name' => 'Regular Expression',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'regex' => [
            'name' => 'Regular Expression',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'rs' => [
            'name' => 'Rust',
            'group' => null,
            'color' => '#dea584',
            'ace' => 'rust',
            'cm' => 'rust',
        ],
        'rsh' => [
            'name' => 'RenderScript',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ring' => [
            'name' => 'Ring',
            'group' => null,
            'color' => '#0e60e3',
            'ace' => 'text',
            'cm' => null,
        ],
        'robot' => [
            'name' => 'RobotFramework',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'man' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        1 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        '1in' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        '1m' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        '1x' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        2 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        3 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        '3in' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        '3m' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        '3qt' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        '3x' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        4 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        5 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        6 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        7 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        8 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        9 => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'me' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'nr' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'roff' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'tmac' => [
            'name' => 'Roff',
            'group' => null,
            'color' => '#ecdebe',
            'ace' => 'text',
            'cm' => 'troff',
        ],
        'rg' => [
            'name' => 'Rouge',
            'group' => null,
            'color' => '#cc0088',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'rb' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'builder' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'eye' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'gemspec' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'god' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'jbuilder' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'mspec' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'pluginspec' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'podspec' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'rabl' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'rake' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'rbuild' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'rbw' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'rbx' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'ru' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'ruby' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'thor' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'watchr' => [
            'name' => 'Ruby',
            'group' => null,
            'color' => '#701516',
            'ace' => 'ruby',
            'cm' => 'ruby',
        ],
        'rs.in' => [
            'name' => 'Rust',
            'group' => null,
            'color' => '#dea584',
            'ace' => 'rust',
            'cm' => 'rust',
        ],
        'sas' => [
            'name' => 'SAS',
            'group' => null,
            'color' => '#B34936',
            'ace' => 'text',
            'cm' => 'sas',
        ],
        'scss' => [
            'name' => 'SCSS',
            'group' => 'CSS',
            'color' => null,
            'ace' => 'scss',
            'cm' => 'css',
        ],
        'smt2' => [
            'name' => 'SMT',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'smt' => [
            'name' => 'SMT',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'sparql' => [
            'name' => 'SPARQL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'sparql',
        ],
        'rq' => [
            'name' => 'SPARQL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'sparql',
        ],
        'sqf' => [
            'name' => 'SQF',
            'group' => null,
            'color' => '#3F3F3F',
            'ace' => 'text',
            'cm' => null,
        ],
        'hqf' => [
            'name' => 'SQF',
            'group' => null,
            'color' => '#3F3F3F',
            'ace' => 'text',
            'cm' => null,
        ],
        'cql' => [
            'name' => 'SQL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'mysql' => [
            'name' => 'SQL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'tab' => [
            'name' => 'SQL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'udf' => [
            'name' => 'SQL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'viw' => [
            'name' => 'SQL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'db2' => [
            'name' => 'SQLPL',
            'group' => null,
            'color' => null,
            'ace' => 'sql',
            'cm' => 'sql',
        ],
        'srt' => [
            'name' => 'SubRip Text',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ston' => [
            'name' => 'STON',
            'group' => 'Smalltalk',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'svg' => [
            'name' => 'SVG',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'sage' => [
            'name' => 'Sage',
            'group' => 'Python',
            'color' => null,
            'ace' => 'python',
            'cm' => 'python',
        ],
        'sagews' => [
            'name' => 'Sage',
            'group' => 'Python',
            'color' => null,
            'ace' => 'python',
            'cm' => 'python',
        ],
        'sls' => [
            'name' => 'Scheme',
            'group' => null,
            'color' => '#1e4aec',
            'ace' => 'scheme',
            'cm' => 'scheme',
        ],
        'sass' => [
            'name' => 'Sass',
            'group' => 'CSS',
            'color' => null,
            'ace' => 'sass',
            'cm' => 'sass',
        ],
        'scala' => [
            'name' => 'Scala',
            'group' => null,
            'color' => '#c22d40',
            'ace' => 'scala',
            'cm' => 'clike',
        ],
        'kojo' => [
            'name' => 'Scala',
            'group' => null,
            'color' => '#c22d40',
            'ace' => 'scala',
            'cm' => 'clike',
        ],
        'sbt' => [
            'name' => 'Scala',
            'group' => null,
            'color' => '#c22d40',
            'ace' => 'scala',
            'cm' => 'clike',
        ],
        'sc' => [
            'name' => 'SuperCollider',
            'group' => null,
            'color' => '#46390b',
            'ace' => 'text',
            'cm' => null,
        ],
        'scaml' => [
            'name' => 'Scaml',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'scm' => [
            'name' => 'Scheme',
            'group' => null,
            'color' => '#1e4aec',
            'ace' => 'scheme',
            'cm' => 'scheme',
        ],
        'sld' => [
            'name' => 'Scheme',
            'group' => null,
            'color' => '#1e4aec',
            'ace' => 'scheme',
            'cm' => 'scheme',
        ],
        'sps' => [
            'name' => 'Scheme',
            'group' => null,
            'color' => '#1e4aec',
            'ace' => 'scheme',
            'cm' => 'scheme',
        ],
        'ss' => [
            'name' => 'Scheme',
            'group' => null,
            'color' => '#1e4aec',
            'ace' => 'scheme',
            'cm' => 'scheme',
        ],
        'sci' => [
            'name' => 'Scilab',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'sce' => [
            'name' => 'Scilab',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'self' => [
            'name' => 'Self',
            'group' => null,
            'color' => '#0579aa',
            'ace' => 'text',
            'cm' => null,
        ],
        'sh' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'bash' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'bats' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'command' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'ksh' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'sh.in' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'tmux' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'tool' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'zsh' => [
            'name' => 'Shell',
            'group' => null,
            'color' => '#89e051',
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'sh-session' => [
            'name' => 'ShellSession',
            'group' => null,
            'color' => null,
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'shen' => [
            'name' => 'Shen',
            'group' => null,
            'color' => '#120F14',
            'ace' => 'text',
            'cm' => null,
        ],
        'sl' => [
            'name' => 'Slash',
            'group' => null,
            'color' => '#007eff',
            'ace' => 'text',
            'cm' => null,
        ],
        'slim' => [
            'name' => 'Slim',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'text',
            'cm' => 'slim',
        ],
        'smali' => [
            'name' => 'Smali',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'tpl' => [
            'name' => 'Smarty',
            'group' => null,
            'color' => null,
            'ace' => 'smarty',
            'cm' => 'smarty',
        ],
        'sp' => [
            'name' => 'SourcePawn',
            'group' => null,
            'color' => '#5c7611',
            'ace' => 'text',
            'cm' => null,
        ],
        'sma' => [
            'name' => 'SourcePawn',
            'group' => null,
            'color' => '#5c7611',
            'ace' => 'text',
            'cm' => null,
        ],
        'sfd' => [
            'name' => 'Spline Font Database',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => null,
        ],
        'nut' => [
            'name' => 'Squirrel',
            'group' => null,
            'color' => '#800000',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'stan' => [
            'name' => 'Stan',
            'group' => null,
            'color' => '#b2011d',
            'ace' => 'text',
            'cm' => null,
        ],
        'ML' => [
            'name' => 'Standard ML',
            'group' => null,
            'color' => '#dc566d',
            'ace' => 'text',
            'cm' => 'mllike',
        ],
        'fun' => [
            'name' => 'Standard ML',
            'group' => null,
            'color' => '#dc566d',
            'ace' => 'text',
            'cm' => 'mllike',
        ],
        'sig' => [
            'name' => 'Standard ML',
            'group' => null,
            'color' => '#dc566d',
            'ace' => 'text',
            'cm' => 'mllike',
        ],
        'sml' => [
            'name' => 'Standard ML',
            'group' => null,
            'color' => '#dc566d',
            'ace' => 'text',
            'cm' => 'mllike',
        ],
        'do' => [
            'name' => 'Stata',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ado' => [
            'name' => 'Stata',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'doh' => [
            'name' => 'Stata',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ihlp' => [
            'name' => 'Stata',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'mata' => [
            'name' => 'Stata',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'matah' => [
            'name' => 'Stata',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'sthlp' => [
            'name' => 'Stata',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'styl' => [
            'name' => 'Stylus',
            'group' => 'CSS',
            'color' => null,
            'ace' => 'stylus',
            'cm' => null,
        ],
        'sublime-build' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-commands' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-completions' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-keymap' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-macro' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-menu' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-mousemap' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-project' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-settings' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-theme' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime-workspace' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime_metrics' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sublime_session' => [
            'name' => 'Sublime Text Config',
            'group' => 'JSON',
            'color' => null,
            'ace' => 'javascript',
            'cm' => 'javascript',
        ],
        'sss' => [
            'name' => 'SugarSS',
            'group' => 'CSS',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'scd' => [
            'name' => 'SuperCollider',
            'group' => null,
            'color' => '#46390b',
            'ace' => 'text',
            'cm' => null,
        ],
        'swift' => [
            'name' => 'Swift',
            'group' => null,
            'color' => '#ffac45',
            'ace' => 'text',
            'cm' => 'swift',
        ],
        'sv' => [
            'name' => 'SystemVerilog',
            'group' => null,
            'color' => '#DAE1C2',
            'ace' => 'verilog',
            'cm' => 'verilog',
        ],
        'svh' => [
            'name' => 'SystemVerilog',
            'group' => null,
            'color' => '#DAE1C2',
            'ace' => 'verilog',
            'cm' => 'verilog',
        ],
        'vh' => [
            'name' => 'SystemVerilog',
            'group' => null,
            'color' => '#DAE1C2',
            'ace' => 'verilog',
            'cm' => 'verilog',
        ],
        '8xp' => [
            'name' => 'TI Program',
            'group' => null,
            'color' => '#A0AA87',
            'ace' => 'text',
            'cm' => null,
        ],
        '8xk' => [
            'name' => 'TI Program',
            'group' => null,
            'color' => '#A0AA87',
            'ace' => 'text',
            'cm' => null,
        ],
        '8xk.txt' => [
            'name' => 'TI Program',
            'group' => null,
            'color' => '#A0AA87',
            'ace' => 'text',
            'cm' => null,
        ],
        '8xp.txt' => [
            'name' => 'TI Program',
            'group' => null,
            'color' => '#A0AA87',
            'ace' => 'text',
            'cm' => null,
        ],
        'tla' => [
            'name' => 'TLA',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'toml' => [
            'name' => 'TOML',
            'group' => null,
            'color' => null,
            'ace' => 'toml',
            'cm' => 'toml',
        ],
        'txl' => [
            'name' => 'TXL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'tcl' => [
            'name' => 'Tcl',
            'group' => null,
            'color' => '#e4cc98',
            'ace' => 'tcl',
            'cm' => 'tcl',
        ],
        'adp' => [
            'name' => 'Tcl',
            'group' => null,
            'color' => '#e4cc98',
            'ace' => 'tcl',
            'cm' => 'tcl',
        ],
        'tm' => [
            'name' => 'Tcl',
            'group' => null,
            'color' => '#e4cc98',
            'ace' => 'tcl',
            'cm' => 'tcl',
        ],
        'tcsh' => [
            'name' => 'Tcsh',
            'group' => 'Shell',
            'color' => null,
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'csh' => [
            'name' => 'Tcsh',
            'group' => 'Shell',
            'color' => null,
            'ace' => 'sh',
            'cm' => 'shell',
        ],
        'tex' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'aux' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'bbx' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'bib' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'cbx' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'dtx' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'ins' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'lbx' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'ltx' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'mkii' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'mkiv' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'mkvi' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'sty' => [
            'name' => 'TeX',
            'group' => null,
            'color' => '#3D6117',
            'ace' => 'tex',
            'cm' => 'stex',
        ],
        'toc' => [
            'name' => 'World of Warcraft Addon Data',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'tea' => [
            'name' => 'Tea',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'txt' => [
            'name' => 'Text',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'no' => [
            'name' => 'Text',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'textile' => [
            'name' => 'Textile',
            'group' => null,
            'color' => null,
            'ace' => 'textile',
            'cm' => 'textile',
        ],
        'thrift' => [
            'name' => 'Thrift',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'tu' => [
            'name' => 'Turing',
            'group' => null,
            'color' => '#cf142b',
            'ace' => 'text',
            'cm' => null,
        ],
        'ttl' => [
            'name' => 'Turtle',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'turtle',
        ],
        'twig' => [
            'name' => 'Twig',
            'group' => 'HTML',
            'color' => null,
            'ace' => 'twig',
            'cm' => 'twig',
        ],
        'tl' => [
            'name' => 'Type Language',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ts' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'tsx' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'upc' => [
            'name' => 'Unified Parallel C',
            'group' => 'C',
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'anim' => [
            'name' => 'Unity3D Asset',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'asset' => [
            'name' => 'Unity3D Asset',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'mat' => [
            'name' => 'Unity3D Asset',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'meta' => [
            'name' => 'Unity3D Asset',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'prefab' => [
            'name' => 'Unity3D Asset',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'unity' => [
            'name' => 'Unity3D Asset',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        's' => [
            'name' => 'Unix Assembly',
            'group' => 'Assembly',
            'color' => null,
            'ace' => 'assembly_x86',
            'cm' => null,
        ],
        'uno' => [
            'name' => 'Uno',
            'group' => null,
            'color' => null,
            'ace' => 'csharp',
            'cm' => 'clike',
        ],
        'uc' => [
            'name' => 'UnrealScript',
            'group' => null,
            'color' => '#a54c4d',
            'ace' => 'java',
            'cm' => 'clike',
        ],
        'ur' => [
            'name' => 'UrWeb',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'urs' => [
            'name' => 'UrWeb',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'vcl' => [
            'name' => 'VCL',
            'group' => null,
            'color' => '#0298c3',
            'ace' => 'text',
            'cm' => null,
        ],
        'vhdl' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vhd' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vhf' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vhi' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vho' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vhs' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vht' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vhw' => [
            'name' => 'VHDL',
            'group' => null,
            'color' => '#adb2cb',
            'ace' => 'vhdl',
            'cm' => 'vhdl',
        ],
        'vala' => [
            'name' => 'Vala',
            'group' => null,
            'color' => '#fbe5cd',
            'ace' => 'vala',
            'cm' => null,
        ],
        'vapi' => [
            'name' => 'Vala',
            'group' => null,
            'color' => '#fbe5cd',
            'ace' => 'vala',
            'cm' => null,
        ],
        'veo' => [
            'name' => 'Verilog',
            'group' => null,
            'color' => '#b2b7f8',
            'ace' => 'verilog',
            'cm' => 'verilog',
        ],
        'vim' => [
            'name' => 'Vim script',
            'group' => null,
            'color' => '#199f4b',
            'ace' => 'text',
            'cm' => null,
        ],
        'vb' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'bas' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'frm' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'frx' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'vba' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'vbhtml' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'vbs' => [
            'name' => 'Visual Basic',
            'group' => null,
            'color' => '#945db7',
            'ace' => 'text',
            'cm' => 'vb',
        ],
        'volt' => [
            'name' => 'Volt',
            'group' => null,
            'color' => '#1F1F1F',
            'ace' => 'd',
            'cm' => 'd',
        ],
        'vue' => [
            'name' => 'Vue',
            'group' => null,
            'color' => '#2c3e50',
            'ace' => 'html',
            'cm' => null,
        ],
        'mtl' => [
            'name' => 'Wavefront Material',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'obj' => [
            'name' => 'Wavefront Object',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'owl' => [
            'name' => 'Web Ontology Language',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => null,
        ],
        'wast' => [
            'name' => 'WebAssembly',
            'group' => null,
            'color' => '#04133b',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'wat' => [
            'name' => 'WebAssembly',
            'group' => null,
            'color' => '#04133b',
            'ace' => 'lisp',
            'cm' => 'commonlisp',
        ],
        'webidl' => [
            'name' => 'WebIDL',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'webidl',
        ],
        'xbm' => [
            'name' => 'X BitMap',
            'group' => 'C',
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'xpm' => [
            'name' => 'X PixMap',
            'group' => 'C',
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'x10' => [
            'name' => 'X10',
            'group' => null,
            'color' => '#4B6BEF',
            'ace' => 'text',
            'cm' => null,
        ],
        'xc' => [
            'name' => 'XC',
            'group' => null,
            'color' => '#99DA07',
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'xml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'adml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'admx' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ant' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'axml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'builds' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ccproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ccxml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'clixml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'cproject' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'cscfg' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'csdef' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'csl' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'csproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ct' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'depproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'dita' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ditamap' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ditaval' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'dll.config' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'dotsettings' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'filters' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'fsproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'fxml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'glade' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'grxml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'iml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ivy' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'jelly' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'jsproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'kml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'launch' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'mdpolicy' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'mjml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'mxml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'natvis' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ndproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'nproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'nuspec' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'odd' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'osm' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'pkgproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'plist' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'proj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'props' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ps1xml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'psc1' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'pt' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'rdf' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'resx' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'rss' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'scxml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'sfproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'shproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'srdf' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'storyboard' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'stTheme' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'sublime-snippet' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'targets' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'tmCommand' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'tml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'tmLanguage' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'tmPreferences' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'tmSnippet' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'tmTheme' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ui' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'urdf' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'ux' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'vbproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'vcxproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'vsixmanifest' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'vssettings' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'vstemplate' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'vxml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'wixproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'wsdl' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'wsf' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'wxi' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'wxl' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'wxs' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'x3d' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xacro' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xaml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xib' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xlf' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xliff' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xmi' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xml.dist' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xproj' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xsd' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xspec' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xul' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'zcml' => [
            'name' => 'XML',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xsp-config' => [
            'name' => 'XPages',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xsp.metadata' => [
            'name' => 'XPages',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xpl' => [
            'name' => 'XProc',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xproc' => [
            'name' => 'XProc',
            'group' => null,
            'color' => null,
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xquery' => [
            'name' => 'XQuery',
            'group' => null,
            'color' => '#5232e7',
            'ace' => 'xquery',
            'cm' => 'xquery',
        ],
        'xq' => [
            'name' => 'XQuery',
            'group' => null,
            'color' => '#5232e7',
            'ace' => 'xquery',
            'cm' => 'xquery',
        ],
        'xql' => [
            'name' => 'XQuery',
            'group' => null,
            'color' => '#5232e7',
            'ace' => 'xquery',
            'cm' => 'xquery',
        ],
        'xqm' => [
            'name' => 'XQuery',
            'group' => null,
            'color' => '#5232e7',
            'ace' => 'xquery',
            'cm' => 'xquery',
        ],
        'xqy' => [
            'name' => 'XQuery',
            'group' => null,
            'color' => '#5232e7',
            'ace' => 'xquery',
            'cm' => 'xquery',
        ],
        'xs' => [
            'name' => 'XS',
            'group' => null,
            'color' => null,
            'ace' => 'c_cpp',
            'cm' => 'clike',
        ],
        'xslt' => [
            'name' => 'XSLT',
            'group' => null,
            'color' => '#EB8CEB',
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xsl' => [
            'name' => 'XSLT',
            'group' => null,
            'color' => '#EB8CEB',
            'ace' => 'xml',
            'cm' => 'xml',
        ],
        'xojo_code' => [
            'name' => 'Xojo',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'xojo_menu' => [
            'name' => 'Xojo',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'xojo_report' => [
            'name' => 'Xojo',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'xojo_script' => [
            'name' => 'Xojo',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'xojo_toolbar' => [
            'name' => 'Xojo',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'xojo_window' => [
            'name' => 'Xojo',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'xtend' => [
            'name' => 'Xtend',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'yml' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'mir' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'reek' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'rviz' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'sublime-syntax' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'syntax' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'yaml' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'yaml-tmlanguage' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'yml.mysql' => [
            'name' => 'YAML',
            'group' => null,
            'color' => null,
            'ace' => 'yaml',
            'cm' => 'yaml',
        ],
        'yang' => [
            'name' => 'YANG',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'yar' => [
            'name' => 'YARA',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'yara' => [
            'name' => 'YARA',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'y' => [
            'name' => 'Yacc',
            'group' => null,
            'color' => '#4B6C4B',
            'ace' => 'text',
            'cm' => null,
        ],
        'yacc' => [
            'name' => 'Yacc',
            'group' => null,
            'color' => '#4B6C4B',
            'ace' => 'text',
            'cm' => null,
        ],
        'yy' => [
            'name' => 'Yacc',
            'group' => null,
            'color' => '#4B6C4B',
            'ace' => 'text',
            'cm' => null,
        ],
        'zep' => [
            'name' => 'Zephir',
            'group' => null,
            'color' => '#118f9e',
            'ace' => 'php',
            'cm' => null,
        ],
        'zimpl' => [
            'name' => 'Zimpl',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'zmpl' => [
            'name' => 'Zimpl',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'zpl' => [
            'name' => 'Zimpl',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'desktop' => [
            'name' => 'desktop',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'desktop.in' => [
            'name' => 'desktop',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'ec' => [
            'name' => 'eC',
            'group' => null,
            'color' => '#913960',
            'ace' => 'text',
            'cm' => null,
        ],
        'eh' => [
            'name' => 'eC',
            'group' => null,
            'color' => '#913960',
            'ace' => 'text',
            'cm' => null,
        ],
        'edn' => [
            'name' => 'edn',
            'group' => null,
            'color' => null,
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'fish' => [
            'name' => 'fish',
            'group' => 'Shell',
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'mu' => [
            'name' => 'mupad',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => null,
        ],
        'nc' => [
            'name' => 'nesC',
            'group' => null,
            'color' => '#94B0C7',
            'ace' => 'text',
            'cm' => null,
        ],
        'ooc' => [
            'name' => 'ooc',
            'group' => null,
            'color' => '#b0b77e',
            'ace' => 'text',
            'cm' => null,
        ],
        'rst' => [
            'name' => 'reStructuredText',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'rst',
        ],
        'rest' => [
            'name' => 'reStructuredText',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'rst',
        ],
        'rest.txt' => [
            'name' => 'reStructuredText',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'rst',
        ],
        'rst.txt' => [
            'name' => 'reStructuredText',
            'group' => null,
            'color' => null,
            'ace' => 'text',
            'cm' => 'rst',
        ],
        'sed' => [
            'name' => 'sed',
            'group' => null,
            'color' => '#64b970',
            'ace' => 'text',
            'cm' => null,
        ],
        'wdl' => [
            'name' => 'wdl',
            'group' => null,
            'color' => '#42f1f4',
            'ace' => 'text',
            'cm' => null,
        ],
        'wisp' => [
            'name' => 'wisp',
            'group' => null,
            'color' => '#7582D1',
            'ace' => 'clojure',
            'cm' => 'clojure',
        ],
        'prg' => [
            'name' => 'xBase',
            'group' => null,
            'color' => '#403a40',
            'ace' => 'text',
            'cm' => null,
        ],
        'prw' => [
            'name' => 'xBase',
            'group' => null,
            'color' => '#403a40',
            'ace' => 'text',
            'cm' => null,
        ],
    ];

    protected string $name = 'Unknown';
    protected ?string $group = null;
    protected ?string $color = null;
    protected string $aceMode = 'text';
    protected ?string $codeMirrorMode = null;

    public function __construct(string $extension)
    {
        if (!isset(self::MAP[$extension])) {
            return;
        }

        $this->name = self::MAP[$extension]['name'];
        $this->group = self::MAP[$extension]['group'];
        $this->color = self::MAP[$extension]['color'];
        $this->aceMode = self::MAP[$extension]['ace'];
        $this->codeMirrorMode = self::MAP[$extension]['cm'];
    }

    public function getName(): string
    {
        return $this->name;
    }

    public function getGroup(): ?string
    {
        return $this->group;
    }

    public function getColor(): ?string
    {
        return $this->color;
    }

    public function getAceMode(): ?string
    {
        return $this->aceMode;
    }

    public function getCodeMirrorMode(): ?string
    {
        return $this->codeMirrorMode;
    }
}
